
/*
 * ***** BEGIN LICENSE BLOCK *****  
 * Source last modified: $Id: propview_nolist.js,v 1.2 2003/01/24 02:58:50 bgoldfarb Exp $ 
 *   
 * Portions Copyright (c) 1995-2003 RealNetworks, Inc. All Rights Reserved.  
 *       
 * The contents of this file, and the files included with this file, 
 * are subject to the current version of the RealNetworks Public 
 * Source License (the "RPSL") available at 
 * http://www.helixcommunity.org/content/rpsl unless you have licensed 
 * the file under the current version of the RealNetworks Community 
 * Source License (the "RCSL") available at 
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL 
 * will apply. You may also obtain the license terms directly from 
 * RealNetworks.  You may not use this file except in compliance with 
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable 
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for 
 * the rights, obligations and limitations governing use of the 
 * contents of the file. 
 *   
 * This file is part of the Helix DNA Technology. RealNetworks is the 
 * developer of the Original Code and owns the copyrights in the 
 * portions it created. 
 *   
 * This file, and the files included with this file, is distributed 
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY 
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS 
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES 
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET 
 * ENJOYMENT OR NON-INFRINGEMENT. 
 *  
 * Technology Compatibility Kit Test Suite(s) Location:  
 *    http://www.helixcommunity.org/content/tck  
 *  
 * Contributor(s):  
 *   
 * ***** END LICENSE BLOCK ***** *
*/

//<SCRIPT>

function PropListView ( listName, propList, configRootPath, serverMethod,
	sFormName, aDirtyImgNames )
{

	if ( ! PropListView.bIsInitialized )
		PropListView.initClass();

	this.m_name = listName;

	this.m_configRootPath = configRootPath;
	this.m_serverMethod = (serverMethod ? serverMethod : "servvar");

	this.m_propList = propList ;

	this.m_submitString = "";
	this.m_oWin = null;
	this.m_oDoc = null;

	this.m_sFormName = sFormName ;
	this.m_aDirtyImgNames = (aDirtyImgNames ? aDirtyImgNames : ["IMG_DIRTY_TAB", "IMG_DIRTY_APPLY"] );

	this.m_parent = null ;

	this.m_resultsTitleListIndex = 3;
	this.m_resultsTitlePropIndex = 4;

	this.m_origClickHandler = null;
	this.m_origKeyUpHandler = null;

	this.m_bDoDirtyCheck = true ;

	this.m_imgSrcDirty = PropListView.imgSrcDirty;
	this.m_imgSrcClean = PropListView.imgSrcClean;

	this.m_hDirtyCheckTimerID = null;

	this.m_subViews = new Array();

	this.m_bLoaded = false;

}	// PropListView ()

// class data
PropListView.aDirtyImgNames = null;
PropListView.imgSrcDirty = null;
PropListView.imgSrcClean = null;
PropListView.bIsInitialized = false;

PropListView.InitClass = function ()
{
	// initialize class data
	PropListView.aDirtyImgNames = ["IMG_DIRTY_TAB", "IMG_DIRTY_APPLY"];
	PropListView.imgSrcDirty = new Image();
	PropListView.imgSrcDirty.src = "images/arrow.gif" ;
	PropListView.imgSrcClean = new Image();
	PropListView.imgSrcClean.src = "images/spacer.gif" ;

	PropListView.DIRTY_CHECK_SUPRESS_TIME = 1000 ;	//millisecs

	PropListView.bIsInitialized = true;
}

PropListView.prototype.addSubView = function ( subView )
{

	this.m_subViews[ subView.m_name ] = subView ;
	subView.m_parent = this ;

	// a sub view shouldn't do dirty checks - presumably the parent does 'em
	subView.m_bDoDirtyCheck = false ;

}	// addSubView ()

PropListView.prototype.toString = function ()
{
	return this.m_name ;
}

PropListView.prototype.subView = function ( subViewName )
{
	return this.m_subViews[ subViewName ];
}

PropListView.prototype.formName = function ( sFormName )
{
	if ( sFormName )
	{
		this.m_sFormName = sFormName ;
	}

	return this.m_sFormName ;
}

PropListView.prototype.getForm = function ( subListName )
{
	return getElem( this.m_sFormName );
}

PropListView.prototype.preOnLoad = function ()
{
	return true ; // continue with super class onLoad
}

/* 
	before calling this function make sure the propList member has been initialized.
	
	Call this method from your pages onload handler, passing in the
	following page element/obj references:
		oWin		the page's window object, required

	after using the parameters to initialize the object's member properties, onPrelLoad is called. This allows
	subclasses to perform any need initialization. The base class's implementation jsut returns true, if an 
	subclass's onPreLoad returns false the bodyof onLoad is skipped.

	The bodyof this method initializes the form using propList data as well as creating an EditSelect obj
	to tie the list and edit controls together.

	onPostLoad is then called at the end. A do nothing method in the base class onPostLoad should be overridden
	in sub classes to perform custom actions - hide/show/resize elements etc.
*/

PropListView.prototype.onLoad = function ( oWin, fNoInitForm, fNoDisplayData )
{

	// initialize member variables TODO validate parameters	
	if (! oWin ) return;

	if ( ! isXblibInit ) xblibInit();

	this.m_oWin = oWin;
	this.m_oDoc = oWin.document;

	this.m_bLoaded = true ;

	if ( this.preOnLoad() )
	{
		this.m_propList.reset();

		if( this.m_bDoDirtyCheck )
			this.showDirtyFlag( false );

		if ( ! fNoInitForm )
			clearForm( this.getForm() );

		//init any subViews
		for ( var subViewName in this.m_subViews )
		{
			var subView = this.m_subViews[ subViewName ];
			if ( subView )
			{
				subView.onLoad( oWin, true, true );
			}
		}

		if ( ! fNoDisplayData )
		{
			this.initListDataDisplay();
		}

		if ( ! fNoInitForm )
			this.hookForm();
	}
	this.postOnLoad();

}	// onLoad()

PropListView.prototype.initListDataDisplay = function ()
{
	this.m_propList.fillForm( this.getForm() );
}

PropListView.prototype.postOnLoad = function ()
{
	// no return value needed
}

PropListView.prototype.setPropList = function ( propList )
{
	this.m_propList = propList ;

}	// setPropList

PropListView.prototype.preValidate = function ()
{
	return true;
}

/* ------------ validate the form and create the submit string --------------*/
PropListView.prototype.validate = function ( fNoSubmitString )
{
	if ( ! this.m_bLoaded ) return ;

	this.m_submitString = "" ;

	if ( ! this.preValidate() )
	{
		
		return false ;
	}

	var ctrl = this.m_propList.validate( this.getForm() );
	if ( ctrl ) 
	{
		
		return rejectInput( ctrl, this.m_propList.errMsg );
	}

	if ( ! fNoSubmitString )
		this.buildParamString();

	if ( ! this.postValidate() )
	{
		
		return false ;
	}

	// chk for unchanged condition
	if ( (!fNoSubmitString) && (!this.m_submitString) )
	{
		alert( "No changes were made to the " + this.m_name + " settings." );
		return false ;
	}

	return true ;

}	// validate ()

PropListView.prototype.postValidate = function ()
{
	return true;
}

PropListView.prototype.buildParamString = function ()
{
	if ( ! this.m_bLoaded ) return ;

	
	
	function _getInstanceOf_buildParamStringCallback ( obj )
	{
		return function( propList, prop, paramStr )
		{
			return obj.buildParamStringCallback( propList, prop, paramStr );		
		}
	}
	
	this.m_submitString = this.m_propList.buildParamString( 
		this.m_configRootPath, false, _getInstanceOf_buildParamStringCallback( this ) );

}	// buildParamString ()

PropListView.prototype.buildParamStringCallback = function ( propList, prop, paramStr )
{
	return paramStr ;
}

PropListView.prototype.doSubmit = function ()
{
	if ( ! this.m_bLoaded ) return ;

	function _getInstanceOf_resultsCallback ( obj )
	{
		return function(results)
		{
			return obj.resultsCallback(results);		
		}
	}

	var method = (this.m_serverMethod == 
		"servvar" ? (this.m_propList.needRestart() ? "configvar" : "servvar") : this.m_serverMethod);
	raSubmitChanges( method, this.m_submitString, 
		this.m_name + " Settings", _getInstanceOf_resultsCallback( this ) );

	this.m_propList.commit();
	commitForm( this.getForm() );
	
	if( this.m_bDoDirtyCheck )
		this.showDirtyFlag( false );

	this.postSubmit();

}	// doSubmit ()

PropListView.prototype.postSubmit = function ()
{
}	// postSubmit

PropListView.prototype.resultsCallback = function ( results )
{
	// TODO use members to determine the properties to print
	// use the fourth and fifth properties as the result title
	var res;
    for ( var propName in results )
    {
		// shortcut to current result
		res = results[ propName ];
        res.title = propName.rightProp();
	}
}

PropListView.prototype.hookForm = function ()
{
	if ( ! this.m_bLoaded ) return ;

	if( this.m_bDoDirtyCheck )
	{
		//because of Mozilla Bug 49980 (as of 4/11/01) we can't use anonymous functions
		//as event handlers - so we assign the instance method call generated by
		// getInstanceEventHandler() to a variable of TOC window...
		this.m_oWin._onDocClick = getInstanceEventHandler( this, "onFormKeyOrClick" );

		//... and then hook it in as the document's click handler
		this.m_origClickHandler = addEvent( this.m_oDoc, "click", 
			this.m_oWin._onDocClick, 1, "Event.CLICK" );

		// ...do the same for the keyup event
		this.m_oWin._onDocKeyUp = getInstanceEventHandler( this, "onFormKeyOrClick" );
		this.m_origKeyUpHandler = addEvent( this.m_oDoc, "keyup", 
			this.m_oWin._onDocKeyUp, 1, "Event.KEYUP" );

		// ...set up the timeout handler
		this.m_oWin._doDirtyChk = getInstanceEventHandler( this, "doDirtyChk" );
	}

}	// hookForm ()

PropListView.prototype.onFormKeyOrClick = function ( evt )
{
	if ( ! this.m_bLoaded ) return ;

	// if we've already set the time then ignore
	if ( this.m_bDoDirtyCheck && (!this.m_hDirtyCheckTimerID) )
	{
		var oForm = this.getForm();

		// if the event src element is not part of our form then ignore
		var srcElem = ( isIE ? this.m_oWin.event.srcElement : evt.target );
		if ( (srcElem.form && (srcElem.form == oForm)) ||
			 (oForm == getParentByTagName( srcElem, "FORM" )) )
		{
			
			this.m_hDirtyCheckTimerID = this.m_oWin.setTimeout( "_doDirtyChk()", PropListView.DIRTY_CHECK_SUPRESS_TIME );
		}
	}

	var evtType = ( evt ? evt.type : this.m_oWin.event.type );
	if ( this.m_origClickHandler && (evtType == "click") )
	{
		return this.m_origClickHandler( evt );
	}
	else if ( this.m_origKeyUpHandler )
	{
		return this.m_origKeyUpHandler( evt );
	}

	if ( isNav4 )
	  	this.m_oDoc.routeEvent( evt );

	return true ;

}	// onFormKeyOrClick

PropListView.prototype.doDirtyChk = function ()
{
	if ( ! this.m_bLoaded ) return ;

	if ( this.m_bDoDirtyCheck )
	{

		this.showDirtyFlag( this.isDirty() );
		this.m_hDirtyCheckTimerID = null ;
	}
}

PropListView.prototype.isDirty = function ()
{
	if ( ! this.m_bLoaded ) return ;

	
	if ( ! this.m_bDoDirtyCheck ) 
	{
		return false;
	}
	else
	{
		return ( this.m_propList.isFormDirty( this.getForm(), 1 ) || 
				 this.m_propList.isDirty() || this.postIsDirty() );
	}
}

PropListView.prototype.postIsDirty = function ()
{
	return false ;
}

PropListView.prototype.showDirtyFlag = function ( bIsFormDirty )
{
	if ( ! this.m_bLoaded ) return ;

	if ( this.m_bDoDirtyCheck )
	{
		for ( var i = 0; i < this.m_aDirtyImgNames.length; i++ )
		{
			var oImgDirty = getElem( this.m_aDirtyImgNames[ i ] );
			if ( oImgDirty )
			{
				oImgDirty.src = 
				(bIsFormDirty ? 
					this.m_imgSrcDirty.src : 
					this.m_imgSrcClean.src);
			}
		}
	}
}

PropListView.InitClass();

//</SCRIPT>

