
/*
 * ***** BEGIN LICENSE BLOCK *****  
 * Source last modified: $Id: qstr.js,v 1.2 2003/01/24 02:58:50 bgoldfarb Exp $ 
 *   
 * Portions Copyright (c) 1995-2003 RealNetworks, Inc. All Rights Reserved.  
 *       
 * The contents of this file, and the files included with this file, 
 * are subject to the current version of the RealNetworks Public 
 * Source License (the "RPSL") available at 
 * http://www.helixcommunity.org/content/rpsl unless you have licensed 
 * the file under the current version of the RealNetworks Community 
 * Source License (the "RCSL") available at 
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL 
 * will apply. You may also obtain the license terms directly from 
 * RealNetworks.  You may not use this file except in compliance with 
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable 
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for 
 * the rights, obligations and limitations governing use of the 
 * contents of the file. 
 *   
 * This file is part of the Helix DNA Technology. RealNetworks is the 
 * developer of the Original Code and owns the copyrights in the 
 * portions it created. 
 *   
 * This file, and the files included with this file, is distributed 
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY 
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS 
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES 
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET 
 * ENJOYMENT OR NON-INFRINGEMENT. 
 *  
 * Technology Compatibility Kit Test Suite(s) Location:  
 *    http://www.helixcommunity.org/content/tck  
 *  
 * Contributor(s):  
 *   
 * ***** END LICENSE BLOCK ***** *
*/

var sepStr =  ":::" ;

function QStrParser ( href )
{
	this.m_params = new Array();

	var qStr = "" ;
	if ( ! href ) 
	{
		qStr = window.document.location.search.slice( 1 );
	}
	else
	{
		var pos = href.indexOf( '?' );
		if ( pos != -1 )
		{
			qStr = href.slice( pos + 1 );
		}
	}
	if ( !qStr ) return ;	

	var param, paramName, paramValue ;
	var tmp = qStr.split( "&" );
	for ( var i = 0; i < tmp.length; i++ )
	{
		param = tmp[ i ].split( "=" );
		paramName = unescape( param[ 0 ] );
		paramValue = ( param[ 1 ] ? unescape( param[ 1 ] ) : "" );

		this.setParam( paramName, paramValue, 1 );
	}
}

QStrParser.prototype.toString = function ()
{
	var s = "" ;
	for ( var paramName in this.m_params )
	{
		aTemp = this.m_params[ paramName ].split( sepStr );
		for ( var i = 0; i < aTemp.length; i++ )
		{
			if ( s != "" )
			{
				s += "&" ;
			}
			 
			s += escapePlus( paramName ) + "=" + escapePlus( aTemp[ i ] );
		}
	}

	return s ;

}	// QStrParser.prototype.toString

QStrParser.prototype.getParam = function ( paramName )
{
	if ( this.m_params[ paramName ] && 
		 ( -1 != this.m_params[ paramName ].indexOf( sepStr ) ) )
	{
		return this.m_params[ paramName ].split( sepStr );
	}
	
	return this.m_params[ paramName ];
}
		
QStrParser.prototype.setParam = function ( paramName, paramValue, fAppend )
{
	if ( paramValue == null ) 
		paramValue = "" ;

	if ( ! fAppend )
	{
		this.m_params[ paramName ] = paramValue ;
	}
	else
	{
		if ( this.m_params[ paramName ] == null )
		{
			this.m_params[ paramName ] = "" ;
		}
		else if ( this.m_params[ paramName ] != "" )
		{
			this.m_params[ paramName ] += sepStr ;
		}

		this.m_params[ paramName ] += paramValue ;
	}
	
	return this.m_params[ paramName ];
}
		
QStrParser.prototype.delParam = function ( paramName )
{
	delete this.m_params[ paramName ];
	return null ;
}

QStrParser.prototype.fillForm = function ( form )
{
	if ( ! form ) return  ;
	
	for ( var paramName in this.m_params )
	{
		if ( typeof( form[ paramName ] ) == "object" )
		{
			aTemp = this.m_params[ paramName ].split( sepStr );
			for ( var i = 0; i < aTemp.length; i++ )
			{
				setCtrlValue( form[ paramName ],  aTemp[ i ] );
			}
		}
	}

}	// QStrParser.prototype.fillForm

