
/*
 * ***** BEGIN LICENSE BLOCK *****  
 * Source last modified: $Id: results.js,v 1.2 2003/01/24 02:58:50 bgoldfarb Exp $ 
 *   
 * Portions Copyright (c) 1995-2003 RealNetworks, Inc. All Rights Reserved.  
 *       
 * The contents of this file, and the files included with this file, 
 * are subject to the current version of the RealNetworks Public 
 * Source License (the "RPSL") available at 
 * http://www.helixcommunity.org/content/rpsl unless you have licensed 
 * the file under the current version of the RealNetworks Community 
 * Source License (the "RCSL") available at 
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL 
 * will apply. You may also obtain the license terms directly from 
 * RealNetworks.  You may not use this file except in compliance with 
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable 
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for 
 * the rights, obligations and limitations governing use of the 
 * contents of the file. 
 *   
 * This file is part of the Helix DNA Technology. RealNetworks is the 
 * developer of the Original Code and owns the copyrights in the 
 * portions it created. 
 *   
 * This file, and the files included with this file, is distributed 
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY 
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS 
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES 
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET 
 * ENJOYMENT OR NON-INFRINGEMENT. 
 *  
 * Technology Compatibility Kit Test Suite(s) Location:  
 *    http://www.helixcommunity.org/content/tck  
 *  
 * Contributor(s):  
 *   
 * ***** END LICENSE BLOCK ***** *
*/

/* Globals */

var hwndDlg = null ;
var dlgParams = null ;
var oldOnFocus = null ;

var defOptions = 'status=no,resizable=yes,dependent=yes,scrollbars=' ; // MUST append "yes" or "no" !!!!

function _configOnLoadDefault ( nextHandler )
{
	if ( isMac && isNav && document.MACFIX )
		document.MACFIX.hidden=true;

	if ( (typeof( pendingChanges ) != "undefined") && pendingChanges )
		doPendingChanges();

	// set frameset title to reflect main frame title
	if ( isIE ) 
		top.document.title = top.origTitle + " | " + document.title ; 

	if ( nextHandler )
		nextHandler();
}

function _configOnUnLoadDefault ( nextHandler )
{
	// reset frameset title
	if ( isIE && top.document.title ) 
		top.document.title = top.origTitle ;

	//use a cookie to store the last page viewed

	//get location.pathname and lop off everything but the filename and querystring
	page = location.pathname ;
	page = page.slice( page.lastIndexOf( '/' ) + 1 );

	if ( top.theCookieJar && page && 
		(!(page.bSearch( /serve_me.html/i ) || page.bSearch( /^server\..*\.html/i ))) )
	{
		top.theCookieJar.lastPage = page;
		top.theCookieJar.store();
	}

	if ( nextHandler )
		nextHandler();
}

function doPendingChanges ()
{
	var headerFrame = findFrame( "Header" );
	var img = getElem( "RESTART_IMG" );
	if ( img && headerFrame )
	{
		var imgSpan = ( isNav4 ? null : getElem( "RESTART_IMG_SPAN" ) );
		headerFrame.restartImage( img, imgSpan );
	}
}

function raSubmitChanges
( 
	chgType,			// "servvar" or "configvar"
	chgParams, 			// parameter string to submit to server

	// following parameters allow the caller to customize the results page
	context,			// the catagory that is being changed "IP Bindings", "Mime Types", etc)
	resultsFunc,		// (optional) function for preprocessing the results array
	propStart			// (optional) starting property of the property path to display, default = 2 (omit "config.")

	/* EX: 
		property = "config.HTTPDeliverable.Path_1"
		propStart = 2
		display = "HTTPDeliverable.Path_1"
	*/
)
{
	dlgParams = new Object();

	var resultsFile = "config_results.nc.html" ;
	var options = defOptions + "yes" + dlgGetDimensons( resultsFile );

	dlgParams.isModal 		= true ;
	dlgParams.isOpen		= false ;

	dlgParams.userParams				= new Object();
	dlgParams.userParams.context		= context ;
	dlgParams.userParams.resultsFunc	= resultsFunc ;
	dlgParams.userParams.propStart		= propStart ;

	oldOnFocus = window.onfocus ;
	window.onfocus = doOnFocus ;

	//	PROCESS ARGS for bad things
	// strip off leading/trailing '&' seperators
	chgParams = chgParams.replace( /^&*/, '' );
	chgParams = chgParams.replace( /&*$/, '' );

	var url = "" ;
	if ( ( chgType == "configvar" ) ||
		 ( chgType == "servvar" ) )
	{
		url = chgType + ".set.html" ;

		if ( chgType == "configvar" )
		{
			// pass along the contextID so that we later associate 
			// each changes with the current page
			if ( contextID )
				chgParams += buildParam( "context", contextID );

			doPendingChanges();
		}
	}
	else
	{
		url = chgType ;
		// when a dialog opens the results window, close that dialog when
		// the results window is closed
		dlgParams.bCloseOpenerOnClose = true ;
	}

	chgParams = "respage=" + resultsFile + "&" + chgParams;

	// use POST method to submit unless the config file sez to use GET, or
	// we can't find the DIV_DYNFORM div to write the the dynamically created form to
	if (  (!getElem( "DIV_DYNFORM" )) ||
		 (top.TOC && (! isBlank( top.TOC.useGetMethod )) && (0 != top.TOC.useGetMethod)) )
	{
		hwndDlg = raSubmitChangesGet( url + "?" + chgParams, options );
	}
	else	// use POST
	{
		// open a blank window to 'target' the form submittal
		if ( window.name != "_RESULTS" )
		{
			hwndDlg = window.open( "", "_RESULTS", options );
		}
		else // this is the results window
		{
			hwndDlg = window ;
		}
		var f = new DynamicForm( "POST", url, "_RESULTS", getElem( "DIV_DYNFORM" ) );

		f.addQStr( chgParams );
		f.submit();
	}
			
	if ( hwndDlg ) hwndDlg.focus();

	return hwndDlg ;
}

function raSubmitChangesGet ( url, options )
{

	var hwndResults = null;

	// already in the results window?
	if ( window.name != "_RESULTS" )
	{
		hwndResults = window.open( url, "_RESULTS", options );
	}
	else
	{
		window.location = url ;
		hwndResults = window ;
	}

	return hwndResults ;
}

function displayChanges ()
{
	var resultsFile = "config_pending.nc.html" ;
	var options = defOptions + "yes" + dlgGetDimensons( resultsFile );

	dlgParams 				= new Object();
	dlgParams.isModal 		= false ;
	dlgParams.isOpen		= false ;
	dlgParams.userParams	= new Object();

 	hwndDlg = window.open( resultsFile, "_CHANGES", options );
	if ( hwndDlg ) hwndDlg.focus();

}	// displayChanges ()

// results window is 'modal' - bounce focus back to it
function doOnFocus ()
{
	if ( hwndDlg && (! hwndDlg.closed) && dlgParams.isOpen )
	{
		hwndDlg.focus();
	}
	else
	{
		hwndDlg = null ;
		dlgParams.isOpen = false ;
		if ( oldOnFocus )
		{
			window.onfocus = oldOnFocus ;
			oldOnFocus = null ;
		}
	}
}

function raDialog
( 
	dialog,
	userParams,
	OKHandler,
	width,
	height,
	scrollbars
)
{
	dlgParams = new Object();

	var options = defOptions + (scrollbars?"yes":"no") + dlgGetDimensons( dialog, width, height );

	// set standard dialog properties
	dlgParams.OKHandler  		= OKHandler ;
	dlgParams.isModal 			= true ;
	dlgParams.isOpen			= false ;

	// setup user properties
	dlgParams.userParams		= userParams ;

	oldOnFocus = window.onfocus ;
	window.onfocus = doOnFocus ;

	// already in the "_DIALOG" window?
	var defName = "_DIALOG" ;
	if ( window.name == defName )
	{
		defName = "_DIALOG_" + dialog.replace( /\..*/, "" );
	}

	hwndDlg = window.open( dialog, defName, options );
	if ( hwndDlg ) hwndDlg.focus();

	return hwndDlg ;
}

function dlgGetDimensons ( dlg,	width, height )
{
	if ( ! (width && height) )
	{
		//strip off url query string
		dlg = dlg.replace( /\?.*/, "" );

		var aDim = dlgDimensions[ dlg.toLowerCase() ];
		if ( aDim == null )	// use defaults
		{
			width  = 460 ;
			height = 380 ;
		}
		else
		{
			if ( aDim.length == 1 )
				aDim = aDim[ 0 ];
			else if ( aDim.length == 2 )
				aDim = aDim[ (isIE ? 0 : 1) ];
			else
				aDim = aDim[ (isIE ? 0 : isWin ? 1 : 2) ];

			width  = aDim[ 0 ];
			height = aDim[ 1 ];
		}
	}

	return ",width=" + width + ",height=" + height +	
		getCenteredCoords( width, height );
}
dlgDimensions = new Array();				//   IE		   Nav on Win	Nav on X/Mac
dlgDimensions[ 'grantuser.html' ]		= [ [ 460, 440 ], [ 480, 480 ], [ 460, 560 ] ];
dlgDimensions[ 'edituserperm.html' ]	= [ [ 460, 460 ], [ 480, 480 ], [ 460, 590 ] ];
dlgDimensions[ 'revokeuser.html' ]		= [ [ 460, 360 ], [ 480, 400 ], [ 460, 440 ] ];
dlgDimensions[ 'revokealluser.html' ]	= [ [ 460, 300 ], [ 480, 320 ], [ 460, 300 ] ];
dlgDimensions[ 'add_redirect.html' ]	= [ [ 460, 300 ], [ 460, 300 ], [ 460, 340 ] ];

dlgDimensions[ 'adduser.html' ]			= [ [ 460, 300 ], [ 480, 310 ], [ 460, 380 ] ];
dlgDimensions[ 'edituser.html' ]		= [ [ 460, 300 ], [ 480, 310 ], [ 460, 390 ] ];
dlgDimensions[ 'removeuser.html' ]	  	= [ [ 460, 260 ], [ 480, 260 ], [ 460, 300 ] ];
dlgDimensions[ 'getusers.html' ]	  	= [ [ 460, 350 ], [ 480, 380 ], [ 460, 440 ] ];

dlgDimensions[ 'cdistpulldown.html' ]  	= [ [ 460, 370 ], [ 480, 400 ], [ 460, 440 ] ];

dlgDimensions[ 'config_results.nc.html' ] = [ [ 600, 480 ] ];
dlgDimensions[ 'config_pending.nc.html' ] = [ [ 600, 540 ] ];
dlgDimensions[ 'ria_status.html' ] 		  = [ [ 600, 640 ] ];

dlgDimensions[ 'prompt_' ] = [ [ 440, 210 ], [ 438, 208 ] ];

function getCenteredCoords ( width, height )
{
	// returns the X and Y coords to center a window with the given dimensions
	// return format is in window.open() style parameters
	return ( (isIE ? ",left=": ",screenX=") + parseInt( (screen.width - width) / 2 ) +
		     (isIE ? ",top=" : ",screenY=") + parseInt( (screen.height- height)/ 2 ) );
}

function checkForPendingChanges ( serverDataChanges )
{

	var isPending = false ;
	function _enumCallback ( a, prop, depth, path )
	{
		if ( a[ prop ] != contextID )
		{
			return 0;
		}
		else
		{
			isPending = true ;
			return 1;	// aborts enum
		}
	}

	// contextID is a global
	if ( serverDataChanges && contextID )
		enumPropArray( serverDataChanges, _enumCallback );

	if ( isPending )
		doPendingChanges();

}	// checkForPendingChanges

function DynamicForm ( sMethod, sAction, sTarget, oDiv /*nav4/IE4 only*/ )
{
	if ( document.getElementById )
	{
		this.m_oForm = document.createElement('FORM');
		this.m_oForm.style.display = "none";
		this.m_oForm.name = "DYN_FORM";
		this.m_oForm.method = sMethod;
		this.m_oForm.action = sAction;
		this.m_oForm.target = sTarget;
		
		document.body.appendChild( this.m_oForm );
	}
	else
	{
		this.m_sFormHTML = '<FORM NAME="DYN_FORM" METHOD="' + 
			sMethod + '" ACTION="' + sAction + '" TARGET="' + sTarget + '">';

		this.m_oDiv = oDiv ;
	}

}	// 

DynamicForm.prototype.addParam = function ( fieldName, fieldValue )
{
	
	if ( document.getElementById )
	{
		var input = document.createElement( 'INPUT' );
		
		if ( !( isIE && isMac) )
		{
			input.type = "hidden";
		}

		input.name = fieldName;
		input.value = fieldValue;
		this.m_oForm.appendChild( input );
	}
	else
	{
		this.m_sFormHTML += "<input type='hidden' name='" + fieldName + "' value='" + fieldValue + "'>" ;
	}

}	// addParam

DynamicForm.prototype.addQStr = function ( sQStr )
{
	var params = sQStr.split( /&/ );
	for ( var i = 0; i < params.length; i++ )
	{
		var parts = params[ i ].split( /=/ );
		if ( ! isBlank( parts[ 0 ] ) )
		{
			this.addParam( unescape( parts[ 0 ] ), 
				(isBlank(parts[ 1 ]) ? "" : unescape( parts[ 1 ] )) );
		}
	}
	
}	// addQStr

DynamicForm.prototype.submit = function ()
{
	if ( ! document.getElementById )
	{
		this.m_sFormHTML += "</FORM>";

		if ( isNav4 )	//Nav4
		{
			
			
			this.m_oDiv.document.open();
			this.m_oDiv.document.write( this.m_sFormHTML );
			this.m_oDiv.document.close();
			
		}
		else	// IE4
		{
			this.m_oDiv.innerHTML = this.m_sFormHTML ;
		}
		this.m_oForm = getElem( "DYN_FORM", (isNav4 ? this.m_oDiv.document : null) );
	}

	if ( this.m_oForm )
	{
		this.m_oForm.submit();
	}

}	// submit

