
/*
 * ***** BEGIN LICENSE BLOCK *****  
 * Source last modified: $Id: string.js,v 1.2 2003/01/24 02:58:50 bgoldfarb Exp $ 
 *   
 * Portions Copyright (c) 1995-2003 RealNetworks, Inc. All Rights Reserved.  
 *       
 * The contents of this file, and the files included with this file, 
 * are subject to the current version of the RealNetworks Public 
 * Source License (the "RPSL") available at 
 * http://www.helixcommunity.org/content/rpsl unless you have licensed 
 * the file under the current version of the RealNetworks Community 
 * Source License (the "RCSL") available at 
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL 
 * will apply. You may also obtain the license terms directly from 
 * RealNetworks.  You may not use this file except in compliance with 
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable 
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for 
 * the rights, obligations and limitations governing use of the 
 * contents of the file. 
 *   
 * This file is part of the Helix DNA Technology. RealNetworks is the 
 * developer of the Original Code and owns the copyrights in the 
 * portions it created. 
 *   
 * This file, and the files included with this file, is distributed 
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY 
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS 
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES 
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET 
 * ENJOYMENT OR NON-INFRINGEMENT. 
 *  
 * Technology Compatibility Kit Test Suite(s) Location:  
 *    http://www.helixcommunity.org/content/tck  
 *  
 * Contributor(s):  
 *   
 * ***** END LICENSE BLOCK ***** *
*/

// string functions

String.prototype.trim = function ( )
{
	var s = this.replace( this.trim.leftTrimRE, '' );
	    s = s.replace( this.trim.rightTrimRE, '' );

	return s ;

}	// trim
String.prototype.trim.leftTrimRE = /^\s*/ ;
String.prototype.trim.rightTrimRE = /\s*$/ ;

String.prototype.leftProp = function ( n )
{
	var pos = this.indexOf( "." );
    if ( pos == -1 ) return this ;
	
	if ( ! n || n == 1 )	
	{
		return this.substr( 0, pos );
	}
	var a = this.split( '.' );
	return a.slice( 0, n ).join( '.' );
}

String.prototype.rightProp = function ( n )
{
    if ( this.indexOf( "." ) == -1 ) return this ;

	if ( ! n || n == 1 )	
	{
		return this.substr( this.lastIndexOf( "." ) + 1 );
	}
	else
	{
		var a = this.split( "." ); 
		if ( n < 0 )
			return a.slice( Math.abs( n ) ).join( "." );
		else
			return a.slice( a.length - n ).join( "." );
	}
}

function entityRE( srchStr, replStr )
{
	this.re = new RegExp();
	this.re.compile( srchStr, "g" );

	this.replStr = replStr ;
}	

entityTable = new Array
(
	new entityRE( "&", "&amp;" ),
	new entityRE( "<", "&lt;" ),
	new entityRE( ">", "&gt;" )
);

function ent ( s )
{
	for ( var x = 0; x < entityTable.length ; x++ )
	{
		s = s.replace( entityTable[ x ].re, entityTable[ x ].replStr );
	}

	return s ;

}	// ent

// method version of ent
String.prototype.ent = function ()
{
	return ent( this );

}	// ent 

// add a span method to the builtin string object
String.prototype.span = function ( _class )	// class is optional
{
	if ( _class )
		return "<span class='" + _class + "'>" + this + "</span>" ;
	else
		return "<span>" + this + "</span>" ;
}

// add a duplicate method to the builtin string object
String.prototype.dup = function ( _count )
{
	var dupStr = "" ;
	for ( var x = 0; x < _count; x++ )
	{
		dupStr += this ;
	}
	return dupStr ;
}

function qEsc( s )
{
	if ( typeof( s ) == "string" )
	{
		s = s.replace( /\\{1}/g, "\\\\" );
		s = s.replace( /\r/g, "\\r" );
		s = s.replace( /\n/g, "\\n" );
		s = s.replace( /'/g, "\\'" );
	}
	return s ;
}

function qqEsc( s )
{
	if ( typeof( s ) == "string" )
	{
		s = s.replace( /\\{1}/g, "\\\\" );
		s = s.replace( /\r/g, "\\r" );
		s = s.replace( /\n/g, "\\n" );
		s = s.replace( /"/g, '\\"' );
	}
	return s ;
}

function qVar ( s )
{
	return "'" + qEsc( s ) + "'" ;
}
	
function qqVar ( s )
{
	return '"' + qqEsc( s ) + '"' ; 
}

String.prototype.pluralize = function ( count, pluralForm )
{
	if ( count == null || count == "" ) count = 0 ;

	if ( count == 1 )
		return this ;
	else
		return ( pluralForm ? pluralForm : this + 's' );
}

function getMachineName ( host )
{
	return isIPAddr( host ) ? host : host.split( '.' )[ 0 ];
}

// checks for the basic IP dotted format
function isIPAddrFormat ( addr )
{

	// just digits and dots?
	return addr.bSearch( /^ *[\d\.]+ *$/ ); 
}

function isIPAddr ( addr, bAllowZero )
{
	if ( isBlank( addr ) )
	{
		return false;
	}
	
	// check the basic form
	if ( ! addr.bSearch( /^(\d{1,3}\.){3}\d{1,3}$/ ) )
	{
		return false ;
	}
	
	var tmpA = addr.split( "." );
	if ( (!bAllowZero) && (parseInt( tmpA[ 0 ] ) == 0) )
	{
		return false;
	}

	for ( var i = 0; i < tmpA.length; i++ )
	{
		var n = parseInt( tmpA[ i ] );
		if ( isNaN( n ) || (n < 0) || (n > 255) )
		{
			return false ;
		}
	}
	
	return true ;
}

String.prototype.bSearch = function ( searchRegExp )
{
	return ( -1 != this.search( searchRegExp ) );
}

function escRegExMetaChars ( s )
{
	return s.replace( /([\\\/\*\.\^\+\$\?\[\]\(\)])/g, "\\$1" );

}	// escRegExMetaChars

function escapePlus ( s )
{
	if ( s == null ) return "";
	
	return escape(s).replace( /\+/, "%2B" );
	
}	// escapePlus

