
/*
 * ***** BEGIN LICENSE BLOCK *****  
 * Source last modified: $Id: xblib.js,v 1.2 2003/01/24 02:58:50 bgoldfarb Exp $ 
 *   
 * Portions Copyright (c) 1995-2003 RealNetworks, Inc. All Rights Reserved.  
 *       
 * The contents of this file, and the files included with this file, 
 * are subject to the current version of the RealNetworks Public 
 * Source License (the "RPSL") available at 
 * http://www.helixcommunity.org/content/rpsl unless you have licensed 
 * the file under the current version of the RealNetworks Community 
 * Source License (the "RCSL") available at 
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL 
 * will apply. You may also obtain the license terms directly from 
 * RealNetworks.  You may not use this file except in compliance with 
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable 
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for 
 * the rights, obligations and limitations governing use of the 
 * contents of the file. 
 *   
 * This file is part of the Helix DNA Technology. RealNetworks is the 
 * developer of the Original Code and owns the copyrights in the 
 * portions it created. 
 *   
 * This file, and the files included with this file, is distributed 
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY 
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS 
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES 
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET 
 * ENJOYMENT OR NON-INFRINGEMENT. 
 *  
 * Technology Compatibility Kit Test Suite(s) Location:  
 *    http://www.helixcommunity.org/content/tck  
 *  
 * Contributor(s):  
 *   
 * ***** END LICENSE BLOCK ***** *
*/

var isXblibInit = false ;

var isOther = true;	// miscellaneous non-supported browsers

var isNav = false;
var isNav4 = false;
var isNav6 = false ;
var isIE = false ;
var isIE4 = false ;
var isIE5 = false ;
var isIE5Up = false ;
var isIE5_5 = false ;
var isW3C = false ;
var isWin = false;
var isMac = false;
var isX11 = false;
var isMoz5 = false;

var docAll = null;

var verMajor = 0;
var verMinor = 0;

var getElem = function(){}

xblibInit();

function xblibInit ()
{
	docAll = document;

	var ver = navigator.appVersion.toLowerCase();
	var agt = navigator.userAgent.toLowerCase(); 

	isWin = (-1 != ver.indexOf( "win" ) ); 
	isMac = (-1 != ver.indexOf( "mac" ) ); 
	isX11 = (-1 != ver.indexOf( "x11" ) ); 

	var pos = ver.indexOf( "msie" );
	if ( -1 == pos )
	{
		isNav = true;
		verMajor = parseInt( ver ); 
		verMinor = parseFloat( ver ); 
	}
	else
	{
		verMajor = parseInt( ver.slice( pos + 4 ) ); 
		verMinor = parseFloat( ver.slice( pos + 4 ) ); 
	}

	if ( document.layers )
	{
		// check for releases prior to 4.06 - they stink!
		isNav4 = ( verMinor >= 4.06 );
		isOther = !isNav4;
	}
	else
	{
		if ( document.all )
		{
			isIE = true ;
			isIE4 = true ;
			isOther = false;
			docAll = document.all ;
		}

		if ( document.getElementById )
		{
			isIE4 = false ;
			isIE5Up = (isIE && (verMajor >= 5));
			isIE5_5 = (isIE && (verMinor >= 5.5));
			isIE5 = (isIE && (verMinor < 5.5));
			isMoz5 = (!isIE);
			isW3C = true ;
			isOther = false;
			docAll = document;
			isNav6 = (-1 != agt.indexOf( "netscape" ) );
		}
	}

	// assign the correct function to the getElem function pointer var
	getElem = (isIE ? (isMac ? getElemIEMac : getElemIE) : isNav4 ? getElemNav4 : getElemNav6);

	isXblibInit = true ;
}

function isObj ( objToTest )
{
	return ( (objToTest != null) &&
			 (typeof(objToTest) == "object") );
}

function addEvent ( obj, evType, fn, useCapture, Nav4EventCode )
{
	if (obj.addEventListener)	// Nav6
	{
		obj.addEventListener( evType, fn, useCapture );
	}
	else if (obj.attachEvent)	// IE 5+
	{
		obj.attachEvent( "on" + evType, fn );
	}
	// IE4, Nav4 - multiple event handlers not supported - use event chaining if
	// multiple events need to be supported
	else
	{
		var origHandler = obj[ "on" + evType ];
		obj[ "on" + evType ] = fn ;
		if ( isNav4 && useCapture && obj.captureEvents && Nav4EventCode )
		{
			obj.captureEvents( eval(Nav4EventCode) );
		}
		return origHandler ;
	}

	return null;
}

function removeEvent ( obj, evType, fn, useCapture, Nav4EventCode, oldHandler )
{
	if (obj.addEventListener)	// Nav6
	{
		obj.removeEventListener( evType, fn, useCapture );
	}
	else if (obj.detachEvent)	// IE 5+
	{
		obj.detachEvent( "on" + evType, fn );
		//obj[ "on" + evType ] = oldHandler ;
	}
	// IE4, Nav4 - multiple event handlers not supported - replace current handler
	// with 'oldHandler' param
	else
	{
		obj[ "on" + evType ] = oldHandler ;
		if ( isNav4 && useCapture && obj.relaseEvents && Nav4EventCode )
		{
			obj.releaseEvents( eval(Nav4EventCode) );
		}
	}
}

function cancelEvent ( e )
{
	if ( ! e ) return false ;
	
	if ( isIE )
	{
		e.cancelBubble = true;
		e.returnValue = false;
	}
	if ( e.cancelable )	e.cancelBubble = true;
	if ( e.stopPropagation ) e.stopPropagation();
	if ( e.preventDefault ) e.preventDefault();

	// for convenience the caller can end it's event handler by 
	// using the return	value of this function, i.e.:
	// return cancelEvent();
	return false ;
}

function getInstanceEventHandler ( obj, handlerName )
{
	function _getInstanceMethodClosure( _obj )
	{
		// Nav passes the event obj to the handler, pass it along to the real handler
		return function(evt)
		{
			return _obj[ handlerName ](evt);		
		}
	}
	
	return _getInstanceMethodClosure( obj );

}	// getInstanceEventHandler

// given and elements ID, return a ref to the corrosponding DOM obj
function getElemIE ( elem, doc ) 
{
	if (! doc ) doc = document;
	return doc.all[ elem ];
}
function getElemIEMac ( elem, doc ) 
{
	if (! doc ) doc = document;
	if ( elem == "" ) return null; // else MacIE 5.0 will barf
	return doc.all[ elem ];
}

function getElemNav4 ( elemName, doc ) 
{
	function _searchElem( _doc )
	{
		// look for a layer
		var elem = _doc.layers[ elemName ];

		if ( isObj( elem ) )
		{
			return elem ;
		}

		// look for a form or a form field
		for ( var x = 0; x < _doc.forms.length; x++ )
		{
			if ( _doc.forms[ x ].name == elemName )
			{
				return _doc.forms[ x ] ;
			}

			// look for a form field
			elem = _doc.forms[ x ][ elemName ];
			if ( isObj( elem ) )
			{
				return elem ;
			}
		}

		// look for an anchor
		for ( var x = 0; x < _doc.anchors.length; x++ )
		{
			if ( _doc.anchors[ x ].name == elemName )
			{
				return _doc.anchors[ x ] ;
			}
		}

		// look for an image
		for ( var x = 0; x < _doc.images.length; x++ )
		{
			if ( _doc.images[ x ].name == elemName )
			{
				return _doc.images[ x ] ;
			}
		}

		// recurse down through the layers
		for ( x = 0; x < _doc.layers.length; x++ )
		{
			elem = _searchElem( _doc.layers[ x ].document );
			if ( isObj( elem ) )
			{
				return elem ;
			}
		}

		return elem ;
	}

	if (! doc ) doc = document;
	return _searchElem( doc );
}

function getElemNav6 ( elemNameOrID, doc ) 
{
	if (! doc ) doc = document;
	var elem = doc.getElementById( elemNameOrID );
	if ( elem ) return elem;
	
	elem = doc.getElementsByName( elemNameOrID );
	if ( elem[0] ) return elem[0];

	return null ;
}

function getChild ( obj, childIndex )
{
	if ( obj.childNodes )
	{
		return obj.childNodes[ childIndex ];
	}
	if ( obj.children )
	{
		return obj.children[ childIndex ];
	}
	else	// not supported
	{
		return null ;	
	}
}

// examine the obj and the ancestors of obj until 
// we find a parent element with the tag tagName
function getParentByTagName ( obj, tagName )
{
	// Nav4 does not support either parent or tagName properties 
	if ( isNav4 ) return obj;
	
	var parentObj = obj;
	while ( parentObj )
	{
		if ( tagName == parentObj.tagName )
		{
			return parentObj ;
		}
		
		parentObj = parentObj.parentNode ? parentObj.parentNode : parentObj.parentElement ;
	}

	return null ;

}	// getParentByTagName

function isElemInView ( elem, win )
{
	if ( ! win ) win = window ;
	if ( isNav4 )
	{
		return (elem.top >= win.pageYOffset) &&
		      ((elem.top + elem.clip.height) <=
		       (win.innerHeight + win.pageYOffset));
	}
	else if ( isIE )
	{
		return (elem.offsetTop >= win.document.body.scrollTop) &&
		       (elem.offsetTop < (win.document.body.scrollTop + win.document.body.offsetHeight));
	}
	else if( isMoz5 )
	{
		return (elem.offsetTop >= win.scrollX) &&
		       (elem.offsetTop < (win.scrollX + win.innerHeight));
	}

}	// isElemInView

function scrollVertToElem ( elem, win )
{
	if ( !win ) win = window ;
	if ( isNav4 )
	{
		if ( (elem.top < win.pageYOffset) || 
		     ((elem.top + elem.clip.height) > 
		      (win.innerHeight + win.pageYOffset)) )
		{
			win.scroll( 0, elem.top );
		}
	}
	else if ( isIE )
	{
		elem.scrollIntoView();
	}
	else
	{
		win.scrollTo( 0, elem.offsetTop );
	}
	
}	// scrollVertToElem

function getTags ( parentObj, tagName )
{
	return (isIE4 ? parentObj.tags( tagName ) : 
			isW3C ?  parentObj.getElementsByTagName( tagName ) : null ); 
}

function setVisibility ( elem, fShow )
{
	var applyToObj = (isNav4 ? elem : elem.style);
	if ( applyToObj )
	{
		applyToObj.visibility = (fShow ? "visible" : "hidden");
	}
	
}	// 

function setDisplay ( elem, fShow )
{
	if ( ! elem ) return;

	if ( isNav4 )
	{
		// display not supported in javascript
		return setVisibility( elem, fShow );
	}
	else
	{
		elem.style.display = (fShow ? "block" : "none");
		elem.style.visibility = (fShow ? "visible" : "hidden");
	}
	
}	// 

// returns an array [left,top] of the absolute position of element elem
// needs work for elems locatated within absolutly positioned elements
function findElemPos ( elem )
{
	var curLeft = 0, curTop = 0;

	if ( elem )
	{
		if ( isNav4 )
		{
			curLeft = elem.x;
			curTop = elem.y;
		}
		else
		{
			curLeft += parseInt( elem.offsetLeft );
			curTop += parseInt( elem.offsetTop );
			/*
			if (window.opera)
			{
				while (obj.tagName != 'HTML')
				{
					obj = obj.parentNode;
					curtop += obj.offsetTop
					curleft += obj.offsetLeft
				}
			}
			else*/ if ( document.all )
			{
				elem = ( isIE4 ? elem.parentElement : elem.parentNode );
				while (elem && elem.tagName != 'HTML')
				{
					// special case for elements located within a table
					if ( elem.tagName && elem.tagName.indexOf( 'T' ) == 0 )
					{
						curLeft += parseInt( elem.offsetLeft );
						curTop += parseInt( elem.offsetTop );
					}
					elem = ( isIE4 ? elem.parentElement : elem.parentNode );
				}
			}
		}
	}

	return [curLeft, curTop];
}

// useful for finding the absolute position of an element especially those nested in
// a table (cell)
// returns an object with x & y properties
function getAbsDim ( elem )
{
	for (var lx = 0, ly = 0; elem != null; 
			lx += elem.offsetLeft, ly += elem.offsetTop, elem = elem.offsetParent );

	return { x:lx, y:ly }
}

